;'TRON.ASM'-V1.0
;This program is set-up too send any .hex file out, throught the printer
;serial port, to any external device. NOTE: This program automatically
;sends a 20H, before hand, to let the external device prepare to receive.

	.IDENT	TRON
	.LOC	100H
	.PABS
	.PHEX

BUFF	=	80H	;READ BUFFER
TYPEF	=	2	;PRINT
BDOS	=	5
PRNTR	=	5
BPRNT	=	9	;BUFFER PRINT
OPENF	=	15	;FILE OPEN
READF	=	20	;READ FILE
DMAF	=	26	;DMA ADDRESS SET
FCB	=	5CH
FCBFT	=	FCB+9	;DISK FILE TYPE

	MVI	A,' '
	CALL	LPRINT	;SEND SYNC BYTE
	MVI	A,'H'
	STA	FCBFT
	MVI	A,'E'
	STA	FCBFT+1
	MVI	A,'X'
	STA	FCBFT+2
	LXI	D,BUFF	;SET DMA ADDRESS
	MVI	C,DMAF
	CALL	BDOS
	LXI	D,FCB	;OPEN FILE
	MVI	C,OPENF
	CALL	BDOS
	CPI	255
	JNZ	RHEX
	LXI	D,OPNMES	;ERROR
	CALL	CONSOL
	JMP	EXIT

GETCHR:	PUSH	D	;GET NEXT CHARACTER
	LDA	IBP
	CPI	80H
	JNZ	GET1

	LXI	D,FCB
	MVI	C,READF	;READ RECORD FROM DISK
	CALL	BDOS
	ORA	A
	JZ	GET1	;READ OK
	POP	D
UNEOF:	LXI	D,UEOF
	CALL	CONSOL
	JMP	EXIT

GET1:	MOV	E,A
	MVI	D,0
	INR	A
	STA	IBP	;UPDATE INDEX
	LXI	H,BUFF
	DAD	D
	MOV	A,M	;GET BYTE FROM BUFFER
	POP	D
	ORA	A
	RET

RHEX:	CALL	GETCHR
	JC	UNEOF
	CPI	':'
	JNZ	RHEX	;WAIT FOR COLON
	MVI	C,0	;CLEAR CHECKSUM
	CALL	GETBYT	;GET HI BYTE OF ADDRESS
	JC	RHEX
	ORA	A
	JZ	EXIT
	MOV	B,A
	CALL	GETBYT	;GET HI BYTE OF ADDRESS
	JC	UNEOF
	MOV	H,A
	CALL	GETBYT
	JC	UNEOF
	MOV	L,A	;LOW BYTE OF ADDRESS
	CALL	GETBYT
	JC	UNEOF
GET5:	CALL	GETBYT
	CALL	LPRINT
	DCR	B
	JNZ	GET5
	CALL	GETBYT
	JC	UNEOF
	MOV	A,C
	ORA	A	;TEST CHECKSUM
	JZ	RHEX

BHEX5:	LXI	D,BHEXD
	CALL	CONSOL
	JMP	EXIT

GETBYT:	PUSH	H
	PUSH	D
	PUSH	B
	CALL	INDIG
	ADD	A
	ADD	A
	ADD	A
	ADD	A
	MOV	D,A
	CALL	INDIG
	JC	GETBY5
	ORA	D
	MOV	D,A
	POP	B
	ADD	C
	MOV	C,A	;UPDATE CHECKSUM
	MOV	A,D
	POP	D
	POP	H
	ORA	A
	RET
INDIG:	CALL	GETCHR
	RC
	SUI	'0'
	CPI	10
	JC	IND1
	CPI	17
	JC	IND2	;BAD HEX DATA
	SUI	7
IND1:	CPI	10H
	JNC	IND2	;BAD HEX DATA
	ORA	A
	RET
IND2:	POP	H
	POP	H
	POP	B
	POP	D
	POP	H
	JMP	BHEX5
GETBY5:	POP	B
	POP	D
	POP	H
	RET

CONSOL:	MVI	C,BPRNT
	CALL	BDOS
	MVI	A,13
	CALL	PRINT
	MVI	A,10
	CALL	PRINT
	RET

PRINT:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	MOV	E,A
	MVI	C,TYPEF
	CALL	BDOS
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET

LPRINT:	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	MOV	E,A
	MVI	C,PRNTR
	CALL	BDOS
	POP	PSW
	POP	B
	POP	D
	POP	H
	RET
	
EXIT:	MVI	C,0
	CALL	BDOS

OPNMES:	.ASCII	'FILE NOT PRESENT$'
UEOF:	.ASCII	'UNEXPECTED END OF FILE$'
BHEXD:	.ASCII	'BAD HEX DATA$'

IBP:	.BYTE	80H

	.END
